/**
 * @file Drv_GPIO.c
 * @author 陳挺 (tony@e-besthealth.com)
 * @brief  GPIO調用接口
 * @version 0.1
 * @date 2020-02-21
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.02
 * MCU/CFG  Ver. : BH67F2472/1.1
 */

#include "Project_Global.h"
#include "BH67F5362.h"
#include "Drv_GPIO.h"

/**
 * @brief GPIO初始化，未使用IO
 * @warning 需要根據實際硬件配置所有IO
 *
 * @note 所有未使用IO設置為輸出 Low
 * @attention 以下複用腳使用第一個功能
 */
void Drv_GPIOPowerOnInit()
{
// PA0-OCDSDA		 PA1-INT0/SCS
// PA2-OCDSCK		 PA3-INT1/SDO
// PA4-INT2/SDI/SDA	 PA5-INT3/SCK/SCL
// PA6-INT0/RX0  	 PA7-INT1/TX0
	_pa   = 0B00000000;
	_pac  = 0B00000000;
	_papu = 0B00000000;
	_pawu = 0B00000000;
	_pas0 = 0B00000000;
	_pas1 = 0B00000000;
// PB0-STCK2/C0X	 PB1-PTCK3	
// PB2-PTCK2/PTP3	 PB3-PTP2/SEG21
// PB4-C1X/SEG22	 PB5-RES/SEG30
// PB6-SPI1/OSC1	 PB7-OSC2/SEG28	
	_pb   = 0B00000000;
	_pbc  = 0B00000000;
	_pbpu = 0B00000000;
	_pbs0 = 0B00000000;
	_pbs1 = 0B00000000;
// PC1-AN1/VREF/COX
// PC2-PTCK6/PTP0/AN2 PC3-PTCK0/PTP4/AN3
// PC4-PTCK7/PTP1/AN4 PC5-PTCK1/PTP5/AN5
// PC6-STP0/AN6       PC7-INT3/STCK0/STP0/AN7		 	
	_pc   = 0B00000000;
	_pcc  = 0B00000000;
	_pcpu = 0B00000000;
	_pcs0 = 0B00000000;
	_pcs1 = 0B00000000;
// PD0-INT2/STP1/AN8 PD1-RX1/AN9
// PD6-STP2/C1X
	_pd   = 0B00000000;
	_pdc  = 0B00000000;
	_pdpu = 0B00000000;
	_pds0 = 0B00000000;
	_pds1 = 0B00000000;
// PE0-STCK0/SPI/SCS
// PE4-VDDIO		 PE5-C2/SEG45/K2
// PE6-C1/SEG44/K1   PE7-V2/SEG43
	_pe   = 0B00000000;
	_pec  = 0B01100000;
	_pepu = 0B01100000;
	_pes0 = 0B00000000;
	_pes1 = 0B00000000;
// PF0-SCS/PTP7	     PF4-PTCK0/XT2
// PF5-PTP0/XT1      PF6-RX1/C0-
// PE7-STP2/TX1/C0+
	_pf   = 0B00000000;
	_pfc  = 0B00000000;
	_pfpu = 0B00000000;
	_pfs0 = 0B00000000;
	_pfs1 = 0B00000000;

}

/**
 * @brief 休眠GPIO配置，未使用 IO 輸出 Low
 *
 */
void Drv_GPIOPowerDownInit()
{
// PA0-OCDSDA		 PA1-INT0/SCS
// PA2-OCDSCK		 PA3-INT1/SDO
// PA4-INT2/SDI/SDA	 PA5-INT3/SCK/SCL
// PA6-INT0/RX0  	 PA7-INT1/TX0
	_pa   = 0B00000000;
	_pac  = 0B00000000;
	_papu = 0B00000000;
	_pawu = 0B00000000;
	_pas0 = 0B00000000;
	_pas1 = 0B00000000;
// PB0-STCK2/C0X	 PB1-PTCK3	
// PB2-PTCK2/PTP3	 PB3-PTP2/SEG21
// PB4-C1X/SEG22	 PB5-RES/SEG30
// PB6-SPI1/OSC1	 PB7-OSC2/SEG28	
	_pb   = 0B00000000;
	_pbc  = 0B00000000;
	_pbpu = 0B00000000;
	_pbs0 = 0B00000000;
	_pbs1 = 0B00000000;
// PC1-AN1/VREF/COX
// PC2-PTCK6/PTP0/AN2 PC3-PTCK0/PTP4/AN3
// PC4-PTCK7/PTP1/AN4 PC5-PTCK1/PTP5/AN5
// PC6-STP0/AN6       PC7-INT3/STCK0/STP0/AN7		 	
	_pc   = 0B00000000;
	_pcc  = 0B00000000;
	_pcpu = 0B00000000;
	_pcs0 = 0B00000000;
	_pcs1 = 0B00000000;
// PD0-INT2/STP1/AN8 PD1-RX1/AN9
// PD6-STP2/C1X
	_pd   = 0B00000000;
	_pdc  = 0B00000000;
	_pdpu = 0B00000000;
	_pds0 = 0B00000000;
	_pds1 = 0B00000000;
// PE0-STCK0/SPI/SCS
// PE4-VDDIO		 PE5-C2/SEG45/K2
// PE6-C1/SEG44/K1   PE7-V2/SEG43
	_pe   = 0B00000000;
	_pec  = 0B00000000;
	_pepu = 0B00000000;
	_pes0 = 0B00000000;
	_pes1 = 0B00000000;
// PF0-SCS/PTP7	     PF4-PTCK0/XT2
// PF5-PTP0/XT1      PF6-RX1/C0-
// PE7-STP2/TX1/C0+
	_pf   = 0B00000000;
	_pfc  = 0B00000000;
	_pfpu = 0B00000000;
	_pfs0 = 0B00000000;
	_pfs1 = 0B00000000;

}